package gov.va.genisis2.service.impl;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import gov.va.genisis2.dao.ILookUpDao;
import gov.va.genisis2.exceptions.GenisisServiceException;
import gov.va.genisis2.model.CommentType;
import gov.va.genisis2.model.DataType;
import gov.va.genisis2.model.FieldToolTipDescription;
import gov.va.genisis2.model.RequestType;
import gov.va.genisis2.model.Source;
import gov.va.genisis2.model.StudyApproval;
import gov.va.genisis2.service.ILookUpService;

@Service
public class LookUpService implements ILookUpService {

	/**
	 * The LOGGER.
	 */
	private static final Logger LOGGER = LoggerFactory.getLogger(LookUpService.class);

	/**
	 * The lookUpDao
	 * 
	 */
	@Autowired
	private ILookUpDao lookUpDao;

	/**
	 * @param lookUpDao the lookUpDao to set
	 */
	public void setLookUpDao(ILookUpDao lookUpDao) {
		this.lookUpDao = lookUpDao;
	}

	/**
	 * This method is used to getStatusId.
	 * 
	 * @param statusDescription
	 *            The statusDescription.
	 * @return int This returns StatusId.
	 * 
	 */
	@Override
	public int getStatusId(String statusDescription) throws GenisisServiceException {

		try {
			return lookUpDao.getStatusId(statusDescription);
		} catch (Exception ex) {
			LOGGER.error("Exception occurred on Status Id", ex);
			throw new GenisisServiceException(ex.getMessage(), ex);
		}
	}
	
	/**
	 * This method is used to getRequestType.
	 * 
	 * @param id
	 *            The id.
	 * @return RequestType This returns RequestType.
	 */
	@Override
	public RequestType getRequestType(int id) throws GenisisServiceException {
		try {
			return lookUpDao.getRequestType(id);
		} catch (Exception ex) {
			LOGGER.error("Exception while querying getRequestType;", ex);
			throw new GenisisServiceException(ex.getMessage(), ex);
		}
	}

	/**
	 * This method is used to getSource.
	 * 
	 * @param id
	 *            The id.
	 * @return Source This returns Source.
	 */
	@Override
	public Source getSource(int id) throws GenisisServiceException {
		try {
			return lookUpDao.getSource(id);
		} catch (Exception ex) {
			LOGGER.error("Exception while querying getSource;", ex);
			throw new GenisisServiceException(ex.getMessage(), ex);
		}
	}


	/**
	 * This method is used to getDataSources.
	 * 
	 * @return this returns list of Source.
	 */
	@Override
	public List<Source> getDataSources() throws GenisisServiceException {
		try {
			return lookUpDao.getDataSources();
		} catch (Exception ex) {
			LOGGER.error("Exception while querying getDataSources;", ex);
			throw new GenisisServiceException(ex.getMessage(), ex);
		}
	}

	/**
	 * This method is used to getRequestTypes.
	 * 
	 * @return this returns list of RequestType.
	 */
	@Override
	public List<RequestType> getRequestTypes() throws GenisisServiceException {
		try {
			return lookUpDao.getRequestTypes();
		} catch (Exception ex) {
			LOGGER.error("Exception while querying getRequestTypes;", ex);
			throw new GenisisServiceException(ex.getMessage(), ex);
		}
	}

	@Override
	public CommentType getCommentType(int id) throws GenisisServiceException {
		try {
			return lookUpDao.getCommentType(id);
		} catch (Exception ex) {
			LOGGER.error("Exception while querying getCommentType;", ex);
			throw new GenisisServiceException(ex.getMessage(), ex);
		}
	}

	
	public List<DataType> getDataTypes() throws GenisisServiceException {
		try {
			return lookUpDao.getDataTypes();
		} catch (Exception ex) {
			LOGGER.error("Exception while querying getDataTypes;", ex);
			throw new GenisisServiceException(ex.getMessage(), ex);
		}
	}

	
	public DataType getDataType(int id) throws GenisisServiceException {
		try {
			return lookUpDao.getDataType(id);
		} catch (Exception ex) {
			LOGGER.error("Exception while querying getDataType;", ex);
			throw new GenisisServiceException(ex.getMessage(), ex);
		}
	}

	@Override
	public List<StudyApproval> getStudyApprovalsByRole(int id) throws GenisisServiceException {
		try {
			return lookUpDao.getStudyApprovalsByRole(id);
		} catch (Exception ex) {
			LOGGER.error("Exception while querying getStudyApprovalsByRole;", ex);
			throw new GenisisServiceException(ex.getMessage(), ex);
		}
	}

	@Override
	public FieldToolTipDescription getTooltipDescription(String fieldName) throws GenisisServiceException {
		try {
			return lookUpDao.getTooltipDescription(fieldName);
		} catch (Exception ex) {
			LOGGER.error("Exception while querying getTooltipDescription;", ex);
			throw new GenisisServiceException(ex.getMessage(), ex);
		}
	}
}
